<?php
header('Content-Type: application/json');

// Récupérer les données JSON envoyées
$json_data = file_get_contents('php://input');
$posts = json_decode($json_data);

// Vérifier que les données sont valides
if ($posts !== null) {
    // Sauvegarder dans posts.json
    $file = 'posts.json';
    $result = file_put_contents($file, json_encode($posts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    if ($result !== false) {
        echo json_encode(['success' => true, 'message' => 'Posts sauvegardés avec succès']);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'écriture du fichier']);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Données JSON invalides']);
}
?>